<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Check if quotation_id column exists
    $stmt = $pdo->prepare("SHOW COLUMNS FROM invoices LIKE 'quotation_id'");
    $stmt->execute();
    $columnExists = $stmt->fetch();
    
    if (!$columnExists) {
        // Add quotation_id column to invoices table
        $pdo->exec("
            ALTER TABLE invoices 
            ADD COLUMN quotation_id INT NULL AFTER customer_id,
            ADD FOREIGN KEY (quotation_id) REFERENCES quotations(id) ON DELETE SET NULL,
            ADD INDEX idx_quotation_id (quotation_id)
        ");
        
        echo "✅ Added quotation_id column to invoices table successfully!\n";
        echo "🔗 Foreign key relationship created:\n";
        echo "   - invoices.quotation_id → quotations.id\n";
    } else {
        echo "ℹ️  quotation_id column already exists in invoices table.\n";
    }

} catch (PDOException $e) {
    echo "❌ Error adding quotation_id column: " . $e->getMessage() . "\n";
} 